;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; builtins.l
;;;   defines C function names for built-in lisp functions.
;;;   When the compiler compiles Lisp function call, it generates
;;;   code to call corresponding C functions if the lisp function 
;;;   symbol has 'comp::builtin-function-entry' property.
;;;
;;;	Copyright 1995, Toshihiro Matsui, Electrotechnical Laboratory
;;;
;;;   Original 1989 (?)
;;;	1996	some functions are added by Ishiwata.


(defun def-builtin-entry (sym lab)
   (putprop sym lab 'builtin-function-entry ))

(def-builtin-entry 'LISP:= "NUMEQUAL")
(def-builtin-entry 'LISP:> "GREATERP")
(def-builtin-entry 'LISP:< "LESSP")
(def-builtin-entry 'LISP:>= "GREQP")
(def-builtin-entry 'LISP:<= "LSEQP")
(def-builtin-entry 'LISP:MOD "MOD")
(def-builtin-entry 'LISP:1- "SUB1")
(def-builtin-entry 'LISP:1+ "ADD1")
(def-builtin-entry 'LISP:+ "PLUS")
(def-builtin-entry 'LISP:- "MINUS")
(def-builtin-entry 'LISP:* "TIMES")
(def-builtin-entry 'LISP:/ "QUOTIENT")
(def-builtin-entry 'LISP:SIN "SIN")
(def-builtin-entry 'LISP:COS "COS")
(def-builtin-entry 'LISP:TAN "TAN")
(def-builtin-entry 'LISP:ATAN "ATAN")
(def-builtin-entry 'LISP:SQRT "SQRT")
(def-builtin-entry 'LISP:LOG "LOG")
(def-builtin-entry 'LISP:EXP "EXP")
(def-builtin-entry 'LISP:ABS "ABS")
(def-builtin-entry 'LISP:ROUND "ROUND")
(def-builtin-entry 'LISP:FLOOR "FLOOR")
(def-builtin-entry 'LISP:CEILING "CEILING")
(def-builtin-entry 'LISP:TRUNCATE "TRUNCATE")
(def-builtin-entry 'LISP:FLOAT "EUSFLOAT")
(def-builtin-entry 'LISP:DECODE-FLOAT "DECFLOAT")
(def-builtin-entry 'LISP:MAX "MAX")
(def-builtin-entry 'LISP:MIN "MIN")
(def-builtin-entry 'LISP:LOGAND "LOGAND")
(def-builtin-entry 'LISP:LOGIOR "LOGIOR")
(def-builtin-entry 'LISP:LOGXOR "LOGXOR")
(def-builtin-entry 'LISP:LOGNOT "LOGNOT")
(def-builtin-entry 'LISP:LOGTEST "LOGTEST")
(def-builtin-entry 'LISP:LOGBITP "LOGBITP")
(def-builtin-entry 'LISP:ASH "ASH")
(def-builtin-entry 'LISP:LDB "LDB")
(def-builtin-entry 'LISP:DPB "DPB")
(def-builtin-entry 'LISP:MAKE-RANDOM-STATE "MAKERANDOMSTATE")
(def-builtin-entry 'LISP:RANDOM "RANDOM")
(def-builtin-entry 'LISP:AREF "AREF")
(def-builtin-entry 'LISP:ASET "ASET")
(def-builtin-entry 'LISP:VECTOR-POP "VECTORPOP")
(def-builtin-entry 'LISP:VECTOR-PUSH "VECTORPUSH")
(def-builtin-entry 'LISP:VECTOR-PUSH-EXTEND "VECTOREXPUSH")
(def-builtin-entry 'LISP:ARRAYP "ARRAYP")
(def-builtin-entry 'LISP:ALPHA-CHAR-P "ALPHAP")
(def-builtin-entry 'LISP:UPPER-CASE-P "UPCASEP")
(def-builtin-entry 'LISP:LOWER-CASE-P "LOWCASEP")
(def-builtin-entry 'LISP:DIGIT-CHAR-P "DIGITP")
(def-builtin-entry 'LISP:ALPHANUMERICP "ALNUMP")
(def-builtin-entry 'LISP:CHAR-UPCASE "CHUPCASE")
(def-builtin-entry 'LISP:CHAR-DOWNCASE "CHDOWNCASE")

(def-builtin-entry 'LISP:COPY-OBJECT "COPYOBJ")
(def-builtin-entry 'LISP:CLASS "GETCLASS")
(def-builtin-entry 'LISP:SEND "SEND")
(def-builtin-entry 'LISP:SEND-MSG "SEND")
(def-builtin-entry 'LISP:SEND-MESSAGE "SENDMESSAGE") 
(def-builtin-entry 'LISP:INSTANTIATE "INSTANTIATE")
(def-builtin-entry 'LISP:CLASSP "CLASSP")
(def-builtin-entry 'LISP:SUBCLASSP "SUBCLASSP")
(def-builtin-entry 'LISP:DERIVEDP "DERIVEDP")
(def-builtin-entry 'LISP:SLOT "SLOT")
(def-builtin-entry 'LISP:SETSLOT "SETSLOT")
(def-builtin-entry 'LISP:CLONE "CLONE")
;;(def-builtin-entry 'SYSTEM::METHOD "FINDMETHOD")
(def-builtin-entry 'SYSTEM::METHOD-CACHE "METHCACHE")

; (def-builtin-entry 'LISP:OPEN "OPEN")	;rewritten in euslisp
(def-builtin-entry 'LISP:CLOSE "CLOSE")
(def-builtin-entry 'LISP:READ "READ")
(def-builtin-entry 'LISP:READ-LINE "READLINE")
(def-builtin-entry 'LISP:READ-CHAR "READCH")
(def-builtin-entry 'LISP:UNREAD-CHAR "UNREADCH")
(def-builtin-entry 'LISP:PEEK-CHAR "PEEKCH")
(def-builtin-entry 'LISP:PRINT "PRINT")
(def-builtin-entry 'LISP:PRIN1 "PRIN1")
(def-builtin-entry 'LISP:PRINC "PRINC")
(def-builtin-entry 'LISP:TERPRI "TERPRI")
(def-builtin-entry 'LISP:PRINT-SIZE "PRNTSIZE")
(def-builtin-entry 'LISP:FINISH-OUTPUT "FINOUT")
(def-builtin-entry 'LISP:WRITE-BYTE "WRTBYTE")
(def-builtin-entry 'LISP:WRITE-WORD "WRTWORD")
(def-builtin-entry 'LISP:WRITE-LONG "WRTLONG")
(def-builtin-entry 'LISP:SET-MACRO-CHARACTER "SETMACROCH")
(def-builtin-entry 'LISP:SET-DISPATCH-MACRO-CHARACTER "SETDISPMACRO")
(def-builtin-entry 'LISP:GET-DISPATCH-MACRO-CHARACTER "GETDISPMACRO")
(def-builtin-entry 'LISP:FORMAT "XFORMAT")
(def-builtin-entry 'system::SAVE "SAVE") 
(def-builtin-entry 'system::BINLOAD "BINLOAD")
(def-builtin-entry 'LISP:V+ "VPLUS")
(def-builtin-entry 'LISP:V- "VMINUS")
(def-builtin-entry 'LISP:V. "VINNERPRODUCT")
(def-builtin-entry 'LISP:V* "VCROSSPRODUCT")
(def-builtin-entry 'LISP:V.* "SCA3PROD")
(def-builtin-entry 'LISP:V< "VLESSP")
(def-builtin-entry 'LISP:V> "VGREATERP")
(def-builtin-entry 'LISP:VMIN "VMIN")
(def-builtin-entry 'LISP:VMAX "VMAX")
(def-builtin-entry 'LISP:MINIMAL-BOX "MINIMALBOX")
(def-builtin-entry 'LISP:SCALE "SCALEVEC")
(def-builtin-entry 'LISP:NORM "VNORM") 
(def-builtin-entry 'LISP:NORM2 "VNORM2") 
(def-builtin-entry 'LISP:NORMALIZE-VECTOR "VNORMALIZE")
(def-builtin-entry 'LISP:DISTANCE "VDISTANCE")
(def-builtin-entry 'LISP:DISTANCE2 "VDISTANCE2")
;; (def-builtin-entry 'LISP:TRIANGLE "TRIANGLE") ;obsolete
(def-builtin-entry 'LISP:FLOATVECTOR "MKFLTVEC")
(def-builtin-entry 'LISP:FLOAT-VECTOR "MKFLTVEC")
(def-builtin-entry 'LISP:TRANSFORM "TRANSFORM")
(def-builtin-entry 'LISP:M* "MATTIMES")
(def-builtin-entry 'LISP:ROTATE-VECTOR "ROTVEC")
(def-builtin-entry 'LISP:ROTATE-MATRIX "ROTMAT")
(def-builtin-entry 'LISP:ROTATION-MATRIX "ROTATION_MATRIX")
(def-builtin-entry 'LISP:ROTATION-ANGLE "ROTANGLE")
(def-builtin-entry 'LISP:TRANSPOSE "TRANSPOSE")
(def-builtin-entry 'LISP:RPY-ANGLE "INV_RPY")
(def-builtin-entry 'LISP:EULER-ANGLE "INV_EULER")
(def-builtin-entry 'LISP:LU-DECOMPOSE "LU_DECOMPOSE")
(def-builtin-entry 'LISP:LU-SOLVE "LU_SOLVE")
(def-builtin-entry 'LISP:LU-DETERMINANT "LU_DETERMINANT")

(def-builtin-entry 'LISP:IDENTITY "IDENTITY")
(def-builtin-entry 'LISP:CAR "CAR")
(def-builtin-entry 'LISP:CAR "FIRST")
(def-builtin-entry 'LISP:CDR "CDR")
(def-builtin-entry 'LISP:REST "CDR")
(def-builtin-entry 'LISP:CADR "CADR")
(def-builtin-entry 'LISP:CADR "SECOND")
(def-builtin-entry 'LISP:CDDR "CDDR")
(def-builtin-entry 'LISP:CDAR "CDAR")
(def-builtin-entry 'LISP:CAAR "CAAR")
(def-builtin-entry 'LISP:CADDR "CADDR")
(def-builtin-entry 'LISP:CADDR "THIRD")
(def-builtin-entry 'LISP:NTH "NTH")
(def-builtin-entry 'LISP:NTHCDR "NTHCDR")
(def-builtin-entry 'LISP:CONS "CONS")
(def-builtin-entry 'LISP:RPLACA "RPLACA")
(def-builtin-entry 'LISP:RPLACA2 "RPLACA2")
(def-builtin-entry 'LISP:RPLACD "RPLACD")
(def-builtin-entry 'LISP:RPLACD2 "RPLACD2")
(def-builtin-entry 'LISP:ATOM "ATOM")
(def-builtin-entry 'LISP:EQ "EQ")
(def-builtin-entry 'LISP:EQL "EQ")
(def-builtin-entry 'LISP:NULL "NILP")
(def-builtin-entry 'LISP:NOT "NILP")
(def-builtin-entry 'LISP:LIST "LIST")
(def-builtin-entry 'LISP:LIST* "LIST_STAR")
(def-builtin-entry 'LISP:EQUAL "EQUAL")
(def-builtin-entry 'LISP:SUPEREQUAL "SUPEREQUAL")
(def-builtin-entry 'LISP:MEMQ "MEMQ")
;;(def-builtin-entry 'LISP:MEMBER "MEMBER")
(def-builtin-entry 'LISP:SUPERMEMBER "SUPERMEMBER")
(def-builtin-entry 'LISP:ASSQ "ASSQ")
;(def-builtin-entry 'LISP:ASSOC "ASSOC")
(def-builtin-entry 'LISP:SUPERASSOC "SUPERASSOC")
(def-builtin-entry 'LISP:APPEND "APPEND")
(def-builtin-entry 'LISP:NCONC "NCONC")
(def-builtin-entry 'LISP:SUBST "SUBST")
(def-builtin-entry 'LISP:NSUBST "NSUBST")
(def-builtin-entry 'LISP:BUTLAST "BUTLAST")
(def-builtin-entry 'LISP:NBUTLAST "NBUTLAST")
(def-builtin-entry 'LISP:SUBSEQ "SUBSEQ")
(def-builtin-entry 'LISP:COPY-SEQ "COPYSEQ")
(def-builtin-entry 'LISP:REVERSE "REVERSE")
(def-builtin-entry 'LISP:NREVERSE "NREVERSE")
(def-builtin-entry 'LISP:CONCATENATE "CONCATENATE")
(def-builtin-entry 'LISP:COERCE "COERCE")
(def-builtin-entry 'LISP:MAP "MAP")

(def-builtin-entry 'SYS::RAW-FILL "FILL")
(def-builtin-entry 'SYS::RAW-POSITION "POSITION")
(def-builtin-entry 'SYS::RAW-COUNT "COUNT")
(def-builtin-entry 'SYS::RAW-FIND "FIND")
(def-builtin-entry 'SYS::RAW-DELETE "DELETE")
(def-builtin-entry 'SYS::RAW-NSUBSTITUTE "NSUBSTITUTE")
(def-builtin-entry 'SYS::RAW-SUBSTITUTE "SUBSTITUTE")
(def-builtin-entry 'SYS::RAW-REMOVE-DUPLICATES "REMOVE_DUPLICATES")
(def-builtin-entry 'SYS::VECTOR-REPLACE "VECREPLACE")
(def-builtin-entry 'SYS::UNIVERSAL-REMOVE "UNIREMOVE")
(def-builtin-entry 'LISP:SORT "SORT")
;;(def-builtin-entry 'LISP:MAKE-VECTOR "MAKEVECTOR")
(def-builtin-entry 'LISP:SVREF "SVREF")
(def-builtin-entry 'LISP:SVSET "SVSET")
(def-builtin-entry 'LISP:LENGTH "LENGTH")
(def-builtin-entry 'LISP:ELT "ELT")
(def-builtin-entry 'LISP:SETELT "SETELT")
(def-builtin-entry 'LISP:CHAR "EUSCHAR")
(def-builtin-entry 'LISP:SETCHAR "SETCHAR")
(def-builtin-entry 'LISP:BIT "BIT")
(def-builtin-entry 'LISP:SETBIT "SETBIT")
(def-builtin-entry 'LISP:VECTOR "MKVECTOR")
(def-builtin-entry 'LISP:INTEGER-VECTOR "MKINTVECTOR")
(def-builtin-entry 'LISP:SYMBOLP "SYMBOLP")
(def-builtin-entry 'LISP:STRINGP "STRINGP")
(def-builtin-entry 'LISP:LISTP "LISTP")
(def-builtin-entry 'LISP:CONSP "CONSP")
(def-builtin-entry 'LISP:ENDP "ENDP")
(def-builtin-entry 'LISP:NUMBERP "NUMBERP")
(def-builtin-entry 'LISP:INTEGERP "INTEGERP")
(def-builtin-entry 'LISP:FLOATP "FLOATP")
(def-builtin-entry 'LISP:VECTORP "VECTORP")
(def-builtin-entry 'LISP:BOUNDP "BOUNDP")
(def-builtin-entry 'LISP:FBOUNDP "FBOUNDP")
(def-builtin-entry 'LISP:STREAMP "STREAMP")
(def-builtin-entry 'LISP:STRING< "STR_LT")
(def-builtin-entry 'LISP:STRING<= "STR_LE")
;; (def-builtin-entry 'LISP:STRING= "STR_EQ")
(def-builtin-entry 'LISP:STRING> "STR_GT")
(def-builtin-entry 'LISP:STRING>= "STR_GE")
(def-builtin-entry 'LISP:EVAL "EVAL")
(def-builtin-entry 'LISP:APPLY "APPLY")
(def-builtin-entry 'LISP:FUNCALL "FUNCALL")
(def-builtin-entry 'LISP:PROG1 "PROG1") 
(def-builtin-entry 'LISP:MAPC "MAPC")
(def-builtin-entry 'LISP:MAPCAR "MAPCAR")
(def-builtin-entry 'LISP:MAPCAN "MAPCAN")
(def-builtin-entry 'LISP:ERROR "SIGERROR")
(def-builtin-entry 'LISP:RESET "RESET")
(def-builtin-entry 'LISP:EVALHOOK "EVALHOOK")
(def-builtin-entry 'LISP:MACROEXPAND2 "MACEXPAND2")
(def-builtin-entry 'LISP:PROCLAIM "PROCLAIM")
(def-builtin-entry 'LISP::SETFUNC "SETFUNC")
(def-builtin-entry 'LISP:SYMBOL-VALUE "SYMVALUE")
(def-builtin-entry 'LISP::SYMBOL-BOUND-VALUE "SYMBNDVALUE")
(def-builtin-entry 'LISP:SYMBOL-FUNCTION "SYMFUNC") 
(def-builtin-entry 'LISP:MAKUNBOUND "MAKUNBOUND")
(def-builtin-entry 'LISP:SET "SETSPECIAL")
(def-builtin-entry 'LISP:FIND-SYMBOL "FINDSYMBOL")
(def-builtin-entry 'LISP:INTERN "INTERN")
(def-builtin-entry 'LISP:GENSYM "GENSYM")
(def-builtin-entry 'LISP:LIST-ALL-PACKAGES "ALLPACKAGES")
(def-builtin-entry 'LISP:FIND-PACKAGE "FINDPACKAGE")
(def-builtin-entry 'SYSTEM::MAKEPACKAGE "MAKEPACKAGE")
;;(def-builtin-entry 'IN-PACKAGE "INPACKAGE") 
(def-builtin-entry 'LISP:SXHASH "SXHASH")
(def-builtin-entry 'LISP:GET    "GETPROP")
(def-builtin-entry 'LISP:EXPORT "EXPORT")
(def-builtin-entry 'LISP:PUTPROP "PUTPROP")

(def-builtin-entry 'UNIX:KILL "KILL")
(def-builtin-entry 'UNIX:SIGNAL "SIGNAL")
(def-builtin-entry 'UNIX::EXIT "EXIT")
(def-builtin-entry 'UNIX:GETPID "GETPID")
(def-builtin-entry 'UNIX:UREAD "UNIXREAD")
(def-builtin-entry 'UNIX:WRITE "UNIXWRITE")
(def-builtin-entry 'UNIX:UCLOSE "UNIXCLOSE")
(def-builtin-entry 'UNIX:IOCTL "IOCTL")
(def-builtin-entry 'UNIX:LSEEK "LSEEK")
(def-builtin-entry 'UNIX::SBRK "SBRK")
(def-builtin-entry 'UNIX:MALLOC "MALLOC")
(def-builtin-entry 'UNIX:FREE "FREE")
(def-builtin-entry 'UNIX:SOCKET "SOCKET")
(def-builtin-entry 'UNIX:BIND "BIND")
(def-builtin-entry 'UNIX:CONNECT "CONNECT")
(def-builtin-entry 'UNIX:LISTEN "LISTEN")
(def-builtin-entry 'UNIX:ACCEPT "ACCEPT")
(def-builtin-entry 'UNIX:SENDTO "SENDTO")
(def-builtin-entry 'UNIX:RECVFROM "RECVFROM")
#-:solaris2
(def-builtin-entry 'UNIX:GETPEERNAME "GETPEERNAME")
(def-builtin-entry 'UNIX:PTIMES "PTIMES")
(def-builtin-entry 'UNIX:RUNTIME "RUNTIME")
(def-builtin-entry 'UNIX:LOCALTIME "LOCALTIME")
(def-builtin-entry 'UNIX:ASCTIME "ASCTIME")
(def-builtin-entry 'UNIX:GETITIMER "GETITIMER")
(def-builtin-entry 'UNIX:SETITIMER "SETITIMER")
#-:solaris2
(progn (def-builtin-entry 'UNIX:GETRUSAGE "GETRUSAGE")
       (def-builtin-entry 'UNIX:GETPAGESIZE "GETPAGESIZE"))
(def-builtin-entry 'UNIX::GETTIMEOFDAY "GETTIMEOFDAY")
(def-builtin-entry 'UNIX:ALARM "ALARM")
(def-builtin-entry 'UNIX:WAIT "WAIT")
(def-builtin-entry 'UNIX:FORK "FORK")
(def-builtin-entry 'UNIX:GETPPID "GETPPID")
(def-builtin-entry 'UNIX:GETPGRP "GETPGRP")
(def-builtin-entry 'UNIX:SETPGRP "SETPGRP")
(def-builtin-entry 'UNIX:GETUID "GETUID")
(def-builtin-entry 'UNIX:GETEUID "GETEUID")
(def-builtin-entry 'UNIX:GETGID "GETGID")
(def-builtin-entry 'UNIX:GETEGID "GETEGID")
(def-builtin-entry 'UNIX:SETUID "SETUID")
(def-builtin-entry 'UNIX:SETGID "SETGID")
(def-builtin-entry 'UNIX:MKNOD "MKNOD")
(def-builtin-entry 'UNIX:FCNTL "FCNTL")
#-:solaris2
(progn (def-builtin-entry 'UNIX:IOCTL_ "IOCTL_")
       (def-builtin-entry 'UNIX:IOCTL_R "IOCTL_R")
       (def-builtin-entry 'UNIX:IOCTL_W "IOCTL_W")
       (def-builtin-entry 'UNIX:IOCTL_WR "IOCTL_WR"))
(def-builtin-entry 'UNIX:DUP "DUP")
(def-builtin-entry 'UNIX:DUP2 "DUP2")
(def-builtin-entry 'UNIX:SYSTEM "SYSTEM")
(def-builtin-entry 'UNIX:GETWD "GETWD")
(def-builtin-entry 'UNIX:GETENV "GETENV")
(def-builtin-entry 'UNIX:SLEEP "SLEEP")
(def-builtin-entry 'UNIX:SYSERRLIST "SYSERRLIST")
(def-builtin-entry 'UNIX:PAUSE "PAUSE")
(def-builtin-entry 'UNIX:ISATTY "ISATTY")
(def-builtin-entry 'UNIX:LINK "LINK")
(def-builtin-entry 'UNIX:UNLINK "UNLINK")
(def-builtin-entry 'UNIX:RENAME "RENAME")
(def-builtin-entry 'UNIX:ACCESS "ACCESS")
;(def-builtin-entry 'UNIX:FLOCK "FLOCK")
(def-builtin-entry 'UNIX:STAT "STAT")
(def-builtin-entry 'UNIX:CHDIR "CHDIR")
(def-builtin-entry 'UNIX:CHMOD "CHMOD")
(def-builtin-entry 'UNIX:CHOWN "CHOWN")
(def-builtin-entry 'UNIX:PIPE "PIPE")
(def-builtin-entry 'UNIX:SELECT "SELECT")
(def-builtin-entry 'UNIX:SELECT-READ-FD "SELECT_READ")
(def-builtin-entry 'UNIX::READDIR "DIRECTORY")
(def-builtin-entry 'UNIX:GETHOSTNAME "GETHOSTNAME")
(def-builtin-entry 'UNIX:GETHOSTBYNAME "GETHOSTBYNAME")
(def-builtin-entry 'UNIX:GETHOSTBYADDR "GETHOSTBYADDR")
(def-builtin-entry 'UNIX:GETNETBYNAME "GETNETBYNAME")
(def-builtin-entry 'UNIX:GETPROTOBYNAME "GETPROTOBYNAME")
(def-builtin-entry 'UNIX:GETSERVBYNAME "GETSERVBYNAME")
#-(or :irix :irix6)
(def-builtin-entry 'UNIX:VFORK "VFORK")
(def-builtin-entry 'UNIX:EXEC "EXEC")
#-:solaris2
(progn (def-builtin-entry 'UNIX:GETPRIORITY "GETPRIORITY")
       (def-builtin-entry 'UNIX:SETPRIORITY "SETPRIORITY"))
(def-builtin-entry 'UNIX:PUTENV "PUTENV")
#-news
(progn (def-builtin-entry 'UNIX:MSGGET "MSGGET")
       (def-builtin-entry 'UNIX:MSGSND "MSGSND")
       (def-builtin-entry 'UNIX:MSGRCV "MSGRCV")
       (def-builtin-entry 'UNIX:MSGCTL "MSGCTL"))
(def-builtin-entry 'UNIX:UNAME "UNAME")

(def-builtin-entry 'SYS::SBCOUNT "SBCOUNT")
(def-builtin-entry 'SYS:GC "GEESEE")
(def-builtin-entry 'SYS:GCTIME "GCTIME")
(def-builtin-entry 'SYS:ALLOC "ALLOC")
(def-builtin-entry 'SYS:NEWSTACK "NEWSTACK")
(def-builtin-entry 'SYS:RECLAIM "RECLAIM")
(def-builtin-entry 'SYS:RECLAIM-TREE "RECLTREE")
(def-builtin-entry 'SYS:OBJECT-SIZE "OBJSIZE")
(def-builtin-entry 'SYS::BKTRACE "BKTRACE")
(def-builtin-entry 'SYS:MEMORY-REPORT "MEMORY_REPORT")
(def-builtin-entry 'SYS:CLEAR-MEMORY-REPORT "CLEAR_ALLOCCOUNT")
(def-builtin-entry 'SYS:ROOM "ROOM")
(def-builtin-entry 'SYS::FREE-COUNT "FREE_COUNTS")
(def-builtin-entry 'SYS:LIST-ALL-CHUNKS "LIST_ALL_CHUNKS")
(def-builtin-entry 'SYS:LIST-ALL-INSTANCES "INSTANCELIST")
(def-builtin-entry 'SYS:ADDRESS "ADDRESS")
(def-builtin-entry 'SYS:PEEK "PEEK")
(def-builtin-entry 'SYS:POKE "POKE")
;(def-builtin-entry 'SYS::MALLOC_DEBUG "MALLOC_DEBUG")
;(def-builtin-entry 'SYS::MALLOC_VERIFY "MALLOC_VERIFY")
(def-builtin-entry 'SYS:LIST-ALL-REFERENCES "LISTALLREFERENCES")
(def-builtin-entry 'SYS:LIST-ALL-CATCHERS "LISTALLCATCHERS")
(def-builtin-entry 'SYS:LIST-ALL-BINDINGS "LISTBINDINGS")
(def-builtin-entry 'SYS:LIST-ALL-SPECIAL-BINDINGS "LISTSPECIALBINDINGS")
(def-builtin-entry 'SYS:LIST-ALL-CLASSES "LISTALLCLASSES")
(def-builtin-entry 'SYS::EXPORT-ALL-SYMBOLS "EXPORTALL")
(def-builtin-entry 'SYS::NEXT-SPECIAL-INDEX "NEXT_SPECIAL_INDEX")
(def-builtin-entry 'SYS::THREAD-SPECIALS "THREAD_SPECIALS")
(def-builtin-entry 'SYS::DISPOSE-HOOK "DISPOSE_HOOK")

#+:thread
(progn
  (def-builtin-entry 'UNIX:THR-SELF "THR_SELF")
  (def-builtin-entry 'UNIX:THR-GETPRIO "THR_GETPRIO")
  (def-builtin-entry 'UNIX:THR-SETPRIO "THR_SETPRIO")
  (def-builtin-entry 'UNIX:THR-GETCONCURRENCY "THR_GETCONCURRENCY")
  (def-builtin-entry 'UNIX:THR-SETCONCURRENCY "THR_SETCONCURRENCY")
  (def-builtin-entry 'UNIX:THR-CREATE "THR_CREATE")
  (def-builtin-entry 'UNIX:THR-KILL "THR_KILL")
  (def-builtin-entry 'UNIX:THR-SUSPEND "THR_SUSPEND")
  (def-builtin-entry 'UNIX:THR-CONTINUE "THR_CONTINUE"))
#+(and :thread :solaris2)
(def-builtin-entry 'UNIX:THR-SIGSETMASK "THR_SIGSETMASK")

#+:thread
(progn
  (def-builtin-entry 'SYS:THREAD-SELF "THREAD_SELF")
  (def-builtin-entry 'SYS:MAKE-THREAD "MAKE_THREAD")
  (def-builtin-entry 'SYS:THREAD "AFUNCALL")
  (def-builtin-entry 'SYS:THREAD-NO-WAIT "AFUNCALL_NO_WAIT")
  (def-builtin-entry 'SYS:WAIT-THREAD "WAIT_AFUNCALL")
  (def-builtin-entry 'SYS::FREE-THREADS "FREE_THREADS")
  (def-builtin-entry 'SYS:MAKE-MUTEX-LOCK "MAKE_MUTEX_LOCK")
  (def-builtin-entry 'SYS:MUTEX-LOCK "MUTEX_LOCK")
  (def-builtin-entry 'SYS:MUTEX-TRYLOCK "MUTEX_TRYLOCK")
  (def-builtin-entry 'SYS:MUTEX-UNLOCK "MUTEX_UNLOCK")
  (def-builtin-entry 'SYS:MAKE-COND "MAKE_COND")
  (def-builtin-entry 'SYS:COND-WAIT "COND_WAIT")
  (def-builtin-entry 'SYS:COND-SIGNAL "COND_SIGNAL")
  (def-builtin-entry 'SYS:MAKE-SEMAPHORE "MAKE_SEMAPHORE")
  (def-builtin-entry 'SYS:SEMA-POST "SEMA_POST")
  (def-builtin-entry 'SYS:SEMA-WAIT "SEMA_WAIT"))
#+(and :thread (or :Solaris2 :alpha))
(def-builtin-entry 'SYS::SEMA-TRYWAIT "SEMA_TRYWAIT")

(provide :builtins "@(#)$Id: builtins.l,v 1.1.1.1 2003/11/20 07:46:27 eus Exp $")
